/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.tileentity;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import lotr.common.fellowship.LOTRFellowship;
import lotr.common.fellowship.LOTRFellowshipData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.chunk.Chunk;
import org.apache.commons.lang3.StringUtils;

public class LOTRTileEntityBeacon
extends TileEntity {
    private int ticksExisted;
    private boolean isLit;
    private int litCounter;
    private int unlitCounter;
    private long stateChangeTime = -1L;
    private String beaconName;
    private UUID beaconFellowshipID;
    private List<EntityPlayer> editingPlayers = new ArrayList<EntityPlayer>();

    public void setLit(boolean flag) {
        boolean wasLit = this.isLit;
        this.isLit = flag;
        if (!this.isLit) {
            this.litCounter = 0;
        } else {
            this.unlitCounter = 0;
        }
        this.updateLight();
        this.stateChangeTime = this.field_145850_b.func_82737_E();
        if (wasLit && !this.isLit) {
            this.sendFellowshipMessage(false);
        }
    }

    private void updateLight() {
        this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
    }

    public boolean isLit() {
        return this.isLit;
    }

    public boolean isFullyLit() {
        return this.isLit() && this.litCounter == 100;
    }

    public void func_145845_h() {
        ++this.ticksExisted;
        if (!this.field_145850_b.field_72995_K) {
            if (this.isLit && this.litCounter < 100) {
                ++this.litCounter;
                if (this.litCounter == 100) {
                    this.updateLight();
                    this.sendFellowshipMessage(true);
                }
            }
            if (!this.isLit && this.unlitCounter < 100) {
                ++this.unlitCounter;
                if (this.unlitCounter == 100) {
                    this.updateLight();
                }
            }
            if (this.ticksExisted % 10 == 0) {
                boolean spreadUnlit;
                boolean spreadLit = this.isLit && this.litCounter >= 100;
                boolean bl = spreadUnlit = !this.isLit && this.unlitCounter >= 100;
                if (spreadLit || spreadUnlit) {
                    ArrayList<LOTRTileEntityBeacon> nearbyTiles = new ArrayList<LOTRTileEntityBeacon>();
                    int range = 88;
                    int chunkRange = range >> 4;
                    int chunkX = this.field_145851_c >> 4;
                    int chunkZ = this.field_145849_e >> 4;
                    ChunkCoordinates coordsThis = new ChunkCoordinates(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    for (int i1 = -chunkRange; i1 <= chunkRange; ++i1) {
                        for (int k1 = -chunkRange; k1 <= chunkRange; ++k1) {
                            Chunk chunk;
                            int i2 = chunkX + i1;
                            int k2 = chunkZ + k1;
                            if (!this.field_145850_b.func_72863_F().func_73149_a(i2, k2) || (chunk = this.field_145850_b.func_72964_e(i2, k2)) == null) continue;
                            for (Object obj : chunk.field_150816_i.values()) {
                                TileEntity te = (TileEntity)obj;
                                if (te.func_145837_r() || !(te instanceof LOTRTileEntityBeacon)) continue;
                                LOTRTileEntityBeacon beacon = (LOTRTileEntityBeacon)te;
                                if (coordsThis.func_71569_e(beacon.field_145851_c, beacon.field_145848_d, beacon.field_145849_e) > 6400.0f) continue;
                                nearbyTiles.add(beacon);
                            }
                        }
                    }
                    if (spreadLit) {
                        for (LOTRTileEntityBeacon other : nearbyTiles) {
                            if (other.isLit || this.stateChangeTime <= other.stateChangeTime) continue;
                            other.setLit(true);
                        }
                    }
                    if (spreadUnlit) {
                        for (LOTRTileEntityBeacon other : nearbyTiles) {
                            if (!other.isLit || this.stateChangeTime <= other.stateChangeTime) continue;
                            other.setLit(false);
                        }
                    }
                }
            }
        }
        HashSet<EntityPlayer> removePlayers = new HashSet<EntityPlayer>();
        for (EntityPlayer entityplayer : this.editingPlayers) {
            if (!entityplayer.field_70128_L) continue;
            removePlayers.add(entityplayer);
        }
        this.editingPlayers.removeAll(removePlayers);
    }

    public boolean isPlayerEditing(EntityPlayer entityplayer) {
        return this.editingPlayers.contains(entityplayer);
    }

    public void addEditingPlayer(EntityPlayer entityplayer) {
        if (!this.editingPlayers.contains(entityplayer)) {
            this.editingPlayers.add(entityplayer);
        }
    }

    public void releaseEditingPlayer(EntityPlayer entityplayer) {
        this.editingPlayers.remove(entityplayer);
    }

    public UUID getFellowshipID() {
        return this.beaconFellowshipID;
    }

    public String getBeaconName() {
        return this.beaconName;
    }

    public void setFellowship(LOTRFellowship fs) {
        this.beaconFellowshipID = fs != null ? fs.getFellowshipID() : null;
        this.beaconFellowshipID = fs == null ? null : fs.getFellowshipID();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
    }

    public void setBeaconName(String name) {
        this.beaconName = name;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
    }

    private void sendFellowshipMessage(boolean lit) {
        LOTRFellowship fs;
        if (this.beaconFellowshipID != null && (fs = LOTRFellowshipData.getFellowship(this.beaconFellowshipID)) != null && !fs.isDisbanded()) {
            String beaconMessageName = this.beaconName;
            if (StringUtils.isBlank((CharSequence)beaconMessageName)) {
                beaconMessageName = fs.getName();
            }
            ChatComponentTranslation message = new ChatComponentTranslation(lit ? "container.lotr.beacon.lit" : "container.lotr.beacon.unlit", new Object[]{beaconMessageName});
            message.func_150256_b().func_150238_a(EnumChatFormatting.YELLOW);
            for (UUID player : fs.getAllPlayerUUIDs()) {
                EntityPlayer entityplayer = this.field_145850_b.func_152378_a(player);
                if (entityplayer == null) continue;
                entityplayer.func_145747_a((IChatComponent)message);
            }
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("IsLit", this.isLit);
        nbt.func_74774_a("LitCounter", (byte)this.litCounter);
        nbt.func_74774_a("UnlitCounter", (byte)this.unlitCounter);
        nbt.func_74772_a("StateChangeTime", this.stateChangeTime);
        if (this.beaconName != null) {
            nbt.func_74778_a("BeaconName", this.beaconName);
        }
        if (this.beaconFellowshipID != null) {
            nbt.func_74778_a("BeaconFellowship", this.beaconFellowshipID.toString());
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.isLit = nbt.func_74767_n("IsLit");
        this.litCounter = nbt.func_74771_c("LitCounter");
        this.unlitCounter = nbt.func_74771_c("UnlitCounter");
        this.stateChangeTime = nbt.func_74763_f("StateChangeTime");
        this.beaconName = nbt.func_74764_b("BeaconName") ? nbt.func_74779_i("BeaconName") : null;
        this.beaconFellowshipID = nbt.func_74764_b("BeaconFellowship") ? UUID.fromString(nbt.func_74779_i("BeaconFellowship")) : null;
    }

    public Packet func_145844_m() {
        NBTTagCompound data = new NBTTagCompound();
        this.func_145841_b(data);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, data);
    }

    public void onDataPacket(NetworkManager manager, S35PacketUpdateTileEntity packet) {
        NBTTagCompound data = packet.func_148857_g();
        this.func_145839_a(data);
        this.updateLight();
    }
}

